#ifndef CE2_TCT_C2_h
#define CE2_TCT_C2_h

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_TST_Config.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Mar 29 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_C2.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_C2_ECB 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of CE2_C2() function in ECB mode;
*
* Algorithm:		
*  -#  											
*
******************************************************************************/	
DxStatus CE2_TST_C2_ECB(FILE *out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_C2_C_CBC 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of CE2_C2() function in C-CBC mode;
*
* Algorithm:		
*  -#  											
*
******************************************************************************/	
DxStatus CE2_TST_C2_C_CBC(FILE *out);


/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_C2_HASH 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of CE2_C2_HASH() function;
*
* Algorithm:		
*  -#  											
*
******************************************************************************/	
DxStatus CE2_TST_C2_HASH(FILE *out);


/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_C2_OneWayFunc 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of CE2_C2_OneWayFunc() function;
*
* Algorithm:		
*  -#  											
*
******************************************************************************/	
DxStatus CE2_TST_C2_OneWayFunc(FILE *out);

#ifdef __cplusplus
}
#endif

#endif /*CE2_TCT_C2_h*/
